/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Last Modification:
    @version $Id: S3M_SVC_Functionlist.h 37179 2013-08-08 10:33:23Z Sven $

   Description:

    SERCOSIIIMaster SVC
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
     1          01.08.2012  SB        rewrite of SVC Task

**************************************************************************************/

#ifndef __S3M_SVC_FUNCTIONLIST_H
#define __S3M_SVC_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * @{
 */

/* compatibility define */
#define TaskEnter_SERCOSIIIMasterSVC TaskEnter_S3M_SVC

void
TaskEnter_S3M_SVC(
    void * pvInit);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define SERCOSIIIMASTER_SVC_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct S3M_SVC_STARTUPPARAMETER_Ttag  S3M_SVC_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct S3M_SVC_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;

  /** A dummy */
  TLR_UINT32  ulDummy;
};

/* compatibility define */
typedef S3M_SVC_STARTUPPARAMETER_T SERCOSIIIMASTER_SVC_STARTUPPARAMETER_T;

/** @} */


/*************************************************************************************/
#endif /* #ifndef __S3M_SVC_FUNCTIONLIST_H */
